/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.widgets;

import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.api.widget.Interactable;
import com.cleanroommc.modularui.drawable.GuiTextures;
import com.cleanroommc.modularui.screen.ModularScreen;
import com.cleanroommc.modularui.utils.VectorUtil;
import com.cleanroommc.modularui.utils.fakeworld.ISchema;
import com.cleanroommc.modularui.utils.fakeworld.SchemaRenderer;
import com.cleanroommc.modularui.widget.Widget;
import com.cleanroommc.modularui.widgets.ButtonWidget;
import net.minecraft.util.MathHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.util.vector.Vector3f;

public class SchemaWidget
extends Widget<SchemaWidget>
implements Interactable {
    public static final float PI = (float)Math.PI;
    public static final float PI2 = (float)Math.PI * 2;
    private final SchemaRenderer schema;
    private boolean enableRotation = true;
    private boolean enableTranslation = true;
    private boolean enableScaling = true;
    private int lastMouseX;
    private int lastMouseY;
    private double scale = 10.0;
    private float pitch = 0.7853982f;
    private float yaw = 0.7853982f;
    private final Vector3f offset = new Vector3f();

    public SchemaWidget(ISchema schema) {
        this(new SchemaRenderer(schema));
    }

    public SchemaWidget(SchemaRenderer schema) {
        this.schema = schema;
        schema.cameraFunc((camera, $schema) -> {
            Vector3f focus = VectorUtil.vec3fAdd(this.offset, null, $schema.getFocus());
            camera.setLookAt(focus, this.scale, (double)this.yaw, (double)this.pitch);
        });
    }

    @Override
    public boolean onMouseScroll(ModularScreen.UpOrDown scrollDirection, int amount) {
        if (this.enableScaling) {
            this.scale((double)(-scrollDirection.modifier * amount) / 120.0);
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public Interactable.Result onMousePressed(int mouseButton) {
        this.lastMouseX = this.getContext().getAbsMouseX();
        this.lastMouseY = this.getContext().getAbsMouseY();
        return Interactable.Result.SUCCESS;
    }

    @Override
    public void onMouseDrag(int mouseButton, long timeSinceClick) {
        int mouseX = this.getContext().getAbsMouseX();
        int mouseY = this.getContext().getAbsMouseY();
        int dx = mouseX - this.lastMouseX;
        int dy = mouseY - this.lastMouseY;
        if (mouseButton == 0 && this.enableRotation) {
            float moveScale = 0.025f;
            this.yaw = (this.yaw + (float)dx * moveScale + (float)Math.PI * 2) % ((float)Math.PI * 2);
            this.pitch = MathHelper.func_76131_a((float)(this.pitch + (float)dy * moveScale), (float)-1.5697963f, (float)1.5697963f);
        } else if (mouseButton == 2 && this.enableTranslation) {
            float y = (float)Math.cos(this.pitch);
            float moveScale = 0.06f;
            this.offset.translate(0.0f, (float)dy * y * moveScale, 0.0f);
            float phi = (this.yaw + 1.5707964f) % ((float)Math.PI * 2);
            float x = (float)Math.cos(phi);
            float z = (float)Math.sin(phi);
            this.offset.translate((float)dx * x * moveScale, 0.0f, (float)dx * z * moveScale);
        }
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
    }

    public SchemaWidget scale(double scale) {
        this.scale += scale;
        return this;
    }

    public SchemaWidget pitch(float pitch) {
        this.pitch += pitch;
        return this;
    }

    public SchemaWidget yaw(float yaw) {
        this.yaw += yaw;
        return this;
    }

    public SchemaWidget offset(float x, float y, float z) {
        this.offset.set(x, y, z);
        return this;
    }

    public SchemaWidget enableDragRotation(boolean enable) {
        this.enableRotation = enable;
        return this;
    }

    public SchemaWidget enableDragTranslation(boolean enable) {
        this.enableTranslation = enable;
        return this;
    }

    public SchemaWidget enableScrollScaling(boolean enable) {
        this.enableScaling = enable;
        return this;
    }

    public SchemaWidget enableInteraction(boolean rotation, boolean translation, boolean scaling) {
        return this.enableDragRotation(rotation).enableDragTranslation(translation).enableScrollScaling(scaling);
    }

    public SchemaWidget enableAllInteraction(boolean enable) {
        return this.enableInteraction(enable, enable, enable);
    }

    @Override
    @Nullable
    public IDrawable getOverlay() {
        return this.schema;
    }

    public static class LayerButton
    extends ButtonWidget<LayerButton> {
        private final int minLayer;
        private final int maxLayer;
        private int currentLayer = Integer.MIN_VALUE;

        public LayerButton(ISchema schema, int minLayer, int maxLayer) {
            this.minLayer = minLayer;
            this.maxLayer = maxLayer;
            this.background(GuiTextures.MC_BACKGROUND);
            this.overlay(IKey.dynamic(() -> this.currentLayer > Integer.MIN_VALUE ? Integer.toString(this.currentLayer) : "ALL").scale(0.5f));
            this.onMousePressed(mouseButton -> {
                if (mouseButton == 0 || mouseButton == 1) {
                    this.currentLayer = mouseButton == 0 ? (this.currentLayer == Integer.MIN_VALUE ? minLayer : ++this.currentLayer) : (this.currentLayer == Integer.MIN_VALUE ? maxLayer : --this.currentLayer);
                    if (this.currentLayer > maxLayer || this.currentLayer < minLayer) {
                        this.currentLayer = Integer.MIN_VALUE;
                    }
                    return true;
                }
                return false;
            });
            schema.setRenderFilter((blockPos, blockInfo) -> this.currentLayer == Integer.MIN_VALUE || this.currentLayer >= blockPos.getY());
        }

        public LayerButton startLayer(int start) {
            this.currentLayer = start;
            return this;
        }
    }
}

